//+------------------------------------------------------------------+
//|                                             MIDAS_Channel_v3.mq4 |
//|                                                       Akif TOKUZ |
//| Implementation is based on article "Introducing the MIDAS Method |
//| of Technical Analysis" by Dr. Paul Levine.                       |
//| Indicator can be started anywhere with dragging a vertical line  |
//|                                                      28.03.2011  |
//+------------------------------------------------------------------+
#property copyright "Akif TOKUZ"
#property link      "akifusenet@gmail.com"

#property indicator_chart_window
#property indicator_buffers 3

//---- input parameters

extern int        VWAPLineWidth        = 2;
extern int        VWAPLineStyle        = STYLE_SOLID;
extern color      VWAPLineColor        = Aqua;

extern int        ResistanceLineWidth  = 1;
extern int        ResistanceLineStyle  = STYLE_SOLID;
extern color      ResistanceLineColor  = Crimson;

extern int        SupportLineWidth     = 1;
extern int        SupportLineStyle     = STYLE_SOLID;
extern color      SupportLineColor     = DodgerBlue;

extern int        CarrierLineWidth     = 1;
extern int        CarrierLineStyle     = STYLE_DOT;
extern color      CarrierLineColor     = DeepSkyBlue;



//---- indicator buffers
double VWAP[];
double VWAP_Resistance[];
double VWAP_Support[];
double CumVol[];
double CumPVol[];
double CumPVol_Resistance[];
double CumPVol_Support[];

//---- global variables for holding up values at fixed "start day"
double CumPVol_J=-1;
double CumPVol_Resistance_J=-1;
double CumPVol_Support_J=-1;
double CumVol_J=-1;




datetime TimeStart;
string NameStart;
int uninitReason;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   IndicatorBuffers(7);

   SetIndexBuffer(0,VWAP);
   SetIndexBuffer(1,VWAP_Resistance);   
   SetIndexBuffer(2,VWAP_Support);   
   SetIndexBuffer(3,CumVol);
   SetIndexBuffer(4,CumPVol);   
   SetIndexBuffer(5,CumPVol_Resistance);   
   SetIndexBuffer(6,CumPVol_Support);   
   
   SetIndexStyle(0,DRAW_LINE,VWAPLineStyle,VWAPLineWidth,VWAPLineColor);
   SetIndexStyle(1,DRAW_LINE,ResistanceLineStyle,ResistanceLineWidth,ResistanceLineColor);
   SetIndexStyle(2,DRAW_LINE,SupportLineStyle,SupportLineWidth,SupportLineColor);

    
   string short_name="MIDAS";
   IndicatorShortName(short_name);
   
   SetIndexLabel(0,"VWAP");
   SetIndexLabel(1,"VWAP_Resistance");
   SetIndexLabel(2,"VWAP_Support");
   
   
   int i=1;   
   do{
      NameStart = "CarrierLine"+"_"+i;
      i++;
   }while(ObjectFind(NameStart) != -1);

   
//----
   return(0);
  }
  
  
  
//+------------------------------------------------------------------+
//| Delete all objects with given prefix                             |
//+------------------------------------------------------------------+
void ObDeleteObjectsByPrefix(string Prefix)
{
   int L = StringLen(Prefix);
   int i = 0; 
   while(i < ObjectsTotal())
   {
       string ObjName = ObjectName(i);
       if(StringSubstr(ObjName, 0, L) != Prefix) 
       { 
           i++; 
           continue;
       }
       ObjectDelete(ObjName);
   }
}
  
  
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+

  int deinit()
  {
      ObDeleteObjectsByPrefix(NameStart);
      return(0);
  }


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int i;
   int counted_bars=IndicatorCounted();

  
   //---- check for possible errors
   if(counted_bars<0) return(-1);
   if(counted_bars>0) counted_bars--;


  if (ObjectFind(NameStart) == -1) {
    TimeStart = iTime(NULL, 0, 20);
    //NameStart = "CarrierLine"+"_"+TimeToStr(TimeStart,TIME_DATE|TIME_MINUTES);
    ObjectCreate(NameStart, OBJ_VLINE, 0, 0, 0);
  }
  if (ObjectGet(NameStart, OBJPROP_TIME1) != TimeStart) {
    ObjectSet(NameStart, OBJPROP_COLOR, CarrierLineColor);
    ObjectSet(NameStart, OBJPROP_BACK, false);
    ObjectSet(NameStart, OBJPROP_WIDTH, CarrierLineWidth);
    ObjectSet(NameStart, OBJPROP_STYLE, CarrierLineStyle);
    if (ObjectGet(NameStart, OBJPROP_TIME1) == 0) ObjectSet(NameStart, OBJPROP_TIME1, TimeStart);
    else TimeStart = ObjectGet(NameStart, OBJPROP_TIME1);

    ArrayInitialize(VWAP,EMPTY_VALUE);
    ArrayInitialize(VWAP_Resistance,EMPTY_VALUE);
    ArrayInitialize(VWAP_Support,EMPTY_VALUE);
    ArrayInitialize(CumVol,0);
    ArrayInitialize(CumPVol,0);
    ArrayInitialize(CumPVol_Resistance,0);
    ArrayInitialize(CumPVol_Support,0);        

  }

   CumPVol_J = -1;
   CumPVol_Resistance_J = -1;
   CumPVol_Support_J = -1;
   CumVol_J = -1;
   int limit = iBarShift(NULL,0,ObjectGet(NameStart, OBJPROP_TIME1));
   
   
 
   for (i=limit; i>=0; i--)
   {
      CumVol[i]=CumVol[i+1]+Volume[i];
      CumPVol[i]=CumPVol[i+1]+Volume[i]*((High[i]+Low[i])/2);
      CumPVol_Resistance[i]=CumPVol_Resistance[i+1]+Volume[i]*High[i];
      CumPVol_Support[i]=CumPVol_Support[i+1]+Volume[i]*Low[i];
      
      
      if (TimeStart <= Time[i])
      {
          if ((CumPVol_J==-1)&&(CumPVol_Resistance_J==-1)&&(CumPVol_Support_J==-1)&&(CumVol_J==-1))        // save starting day values
          {
            CumPVol_J = CumPVol[i];
            CumPVol_Resistance_J = CumPVol_Resistance[i];
            CumPVol_Support_J = CumPVol_Support[i];
            CumVol_J = CumVol[i];          
            VWAP[i]=((High[i]+Low[i])/2); // at the start day we need to put initial values                     
            VWAP_Resistance[i]=High[i];   // which are calculated differently             
            VWAP_Support[i]=Low[i];       // which are calculated differently             
          }else
          {      
            double divider = CumVol[i] - CumVol_J;
            VWAP[i]=( CumPVol[i] - CumPVol_J ) / divider;  
            if (CumPVol[i] - CumPVol_J == 0) VWAP[i]=((High[i]+Low[i])/2);       
            VWAP_Resistance[i]=( CumPVol_Resistance[i] - CumPVol_Resistance_J ) / divider;             
            VWAP_Support[i]=( CumPVol_Support[i] - CumPVol_Support_J ) / divider;             
                                    
         }

         
      }
   }
  
  
   //SetIndexDrawBegin(0,Bars-limit);
  //---- done
  return(0);
   }
//+------------------------------------------------------------------+